' Options.vb - Implementuje utrzymywanie informacji na dwa sposoby korzystajc z 
' konstruktora wspdzielonego i waciwoci
' Copyright (c) 2001. All Rights Reserved.
' Written by Paul Kimmel. pkimmel@softconcepts.com

Imports Microsoft.Win32, System.Collections.Specialized, System.IO

#If DEBUG = False Then

Public Class Options

  Private Sub New()
  End Sub

  Private Enum Keys
    LastFileName
  End Enum

  Public Shared Property LastFileName() As String
    Get
      Return ReadString(Keys.LastFileName.ToString)
    End Get
    Set(ByVal Value As String)
      WriteString(Keys.LastFileName.ToString, Value)
    End Set
  End Property

  Private Shared Function Subkey() As String
    Return "Software\" & "VB.NET UNLEASHED"
  End Function

  Private Shared Function OpenKey() As RegistryKey

    Return Registry.LocalMachine.OpenSubKey(Subkey(), True)

  End Function

  Private Shared Function ReadString(ByVal Key As String, _
    Optional ByVal Value As String = "") As String
    Try
      Return OpenKey().GetValue(Key, Value)
    Catch
      Return Value
    End Try
  End Function

  Private Shared Sub WriteString(ByVal Key As String, _
    ByVal Value As String)
    Try
      OpenKey().SetValue(Key, Value)
    Catch
      Registry.LocalMachine.CreateSubKey(Subkey())
      OpenKey().SetValue(Key, Value)
    End Try
  End Sub


End Class

#Else

Public Class Options

  Private Sub New()

  End Sub

  Private Enum Keys
    LastFileName
  End Enum

  Private Shared Loading As Boolean
  Private Shared FDictionary As HybridDictionary

  Shared Sub New()
    FDictionary = New HybridDictionary()
    LoadDictionary()
  End Sub

  Public Shared Property LastFileName() As String
    Get
      Return ReadString(Keys.LastFileName.ToString)
    End Get
    Set(ByVal Value As String)
      WriteString(Keys.LastFileName.ToString, Value)
    End Set
  End Property


  Private Shared Function ReadString(ByVal Key As String, _
    Optional ByVal Value As String = "")

    If (FDictionary.Item(Key) Is Nothing) Then Return Value
    Return FDictionary.Item(Key)

  End Function

  Private Shared Sub WriteString(ByVal Key As String, _
    ByVal Value As String)
    FDictionary.Remove(Key)
    FDictionary.Add(Key, Value)
    SaveDictionary()
  End Sub

  Private Shared Function GetOptionsFile() As String
    Return Application.StartupPath & "\options.ini"
  End Function

  Private Shared Sub SaveDictionary()
    If (Loading) Then Exit Sub
    Dim Writer As StreamWriter = _
      File.CreateText(GetOptionsFile())
    Try
      Writer.WriteLine(Keys.LastFileName.ToString & "=" & _
        FDictionary.Item(Keys.LastFileName.ToString))
    Finally
      Writer.Close()
    End Try
  End Sub

  Private Shared Sub LoadDictionary()
    If (Not File.Exists(GetOptionsFile())) Then Exit Sub

    Dim Reader As StreamReader = _
      File.OpenText(GetOptionsFile())

    Try
      Loading = True
      Dim Line As String = Reader.ReadLine()
      LastFileName = Mid(Line, InStr(Line, "=") + 1)

    Finally
      Reader.Close()
      Loading = False
    End Try

  End Sub

End Class

#End If
